/* 
 * --------------------
 * Company					: LUOYANG GINGKO TECHNOLOGY CO.,LTD.
 * BBS						: http://www.eeschool.org
 * --------------------
 * Project Name			: SDRAM_Test_Top
 * Module Name				: SDRAM_Test_Top
 * Description				: The codes of "SDRAM_Test_Top"
 * --------------------
 * Tool Versions			: Quartus II 13.1
 * Target Device			: Cyclone IV E  EP4CE10F17C8
 * --------------------
 * Engineer					: xiaorenwu
 * Revision					: V0.0
 * Created Date			: 2014-04-26
 * --------------------
 * Engineer					:
 * Revision					:
 * Modified Date			:
 * --------------------
 * Additional Comments	: SDRAM_Model	W9812G2IH
 * 
 * --------------------
 */

//--------------------Timescale------------------------------//
`timescale 1 ns / 1 ps
//--------------------Module_SDRAM_Test_Top------------------//
module SDRAM_Test_Top(
	FPGA_CLK,	//输入板载晶振GPGA_CLK,25M
	SD_CLK,		//输出以下SDRAM各个控制信号
	SD_CKE,		//时钟使能信号
	SD_CS,		//片选信号
	SD_RAS,		//行选通信号
	SD_CAS,		//列选通信号
	SD_WE,		//读写控制信号
	SD_BA,		//Bank地址选择信号
	SD_AB,		//地址总线
	SD_DB,		//双向数据总线
	SD_DQM,		//数据屏蔽信号
	FPGA_LEDR,
	FPGA_LEDG,
	FPGA_LEDB,
	WR,			//FSMC写信号
	RD,			//FSMC读信号
	CS0,			//FSMC片选
	A,				//FSMC地址总线
	KEY,
	DB,			//FSMC数据总线
	NADV,			//FSMC的NADV
	FPGA_KEY
	);

	input FPGA_KEY;
	input FPGA_CLK,NADV;
	input WR,RD,CS0;
	inout [15:0]DB;
	output KEY;
	input [24:16]A;
	inout  [15:0] SD_DB;
	output SD_CLK,SD_CKE;
	output SD_CS,SD_RAS,SD_CAS,SD_WE;
	output [1:0] SD_BA;
	output [11:0] SD_AB;
	output [1:0] SD_DQM;
	output FPGA_LEDB,FPGA_LEDG,FPGA_LEDR;
	assign SD_CLK = CLK_100M;
	
	assign KEY = FPGA_KEY;
//--------------------MY_PLL---------------------------------//	
	wire PLL_100M;
	MY_PLL				U1(
								.areset(!RST_n),
								.inclk0(FPGA_CLK),
								.c0(PLL_100M),
								.c2(CLK_100M)
								);	//例化MY_PLL模块,输出50M时钟
//--------------------RST_Ctrl-------------------------------//
	wire RST_n;
	RST_Ctrl				U2(
								.FPGA_CLK(FPGA_CLK),
								.RST_n(RST_n)
								);	//例化RST_Ctrl模块,输出全局复位信号RST_n

//--------------------SDRAM_Ctrl_Top-------------------------//
	wire SD_Busy,SD_WR_Ack,SD_RD_Ack,SD_WR_Req,SD_RD_Req,REF_Ack,REF_Req;
	wire [15:0]Sys_Data_out;
	wire [15:0]SDRAM_Data_out;
	wire [21:0]wr_ab,rd_ab;
	
	SDRAM_Ctrl_Top		U3(							//SDRAM驱动（单次读写模式）
								.SDRAM_CLK(PLL_100M),
								.RST_n(RST_n),
								.SDRAM_Data_in(Sys_Data_out),
								.SD_WR_Req(SD_WR_Req),
								.SD_RD_Req(SD_RD_Req),
								.SD_WR_Ack(SD_WR_Ack),
								.SD_RD_Ack(SD_RD_Ack),
								.SD_Busy(SD_Busy),
								.SD_CKE(SD_CKE),
								.SD_CS(SD_CS),
								.SD_RAS(SD_RAS),
								.SD_CAS(SD_CAS),
								.SD_WE(SD_WE),
								.SD_BA(SD_BA),
								.SD_AB(SD_AB),
								.SD_DB(SD_DB),
								.SD_DQM(SD_DQM),
								.SDRAM_Data_out(SDRAM_Data_out),
								.REF_Ack(REF_Ack),
								.REF_Req(REF_Req),
								.wr_ab(wr_ab),
								.rd_ab(rd_ab)
								);	//例化SDRAM_Ctrl_Top模块,控制SDRAM的读写

//--------------------Data_Generator-------------------------//
	Data_Generator		U4(							//SDRAM测试模块
								.SDRAM_CLK(PLL_100M),		
								.RST_n(RST_n),
								.SD_Busy(SD_Busy),
								.SD_WR_Ack(SD_WR_Ack),
								.SD_RD_Ack(SD_RD_Ack),
								.SD_WR_Req(SD_WR_Req),
								.SD_RD_Req(SD_RD_Req),
								.Sys_Data_out(Sys_Data_out),
								.rd_ab(rd_ab),
								.wr_ab(wr_ab),
								.SDRAM_Data_out(SDRAM_Data_out),
								.FPGA_LEDR(FPGA_LEDR),
								.FPGA_LEDG(FPGA_LEDG),
								.FPGA_LEDB(FPGA_LEDB),
								.REF_Ack(REF_Ack),
								.REF_Req(REF_Req)
								);	//例化Data_Generator模块,控制向SDRAM写入测试数据

//--------------------Endmodule------------------------------//
	fsmc					U5(									//FSMC总线测试模块
								.ab(A[24:16]),
								.db(DB),
								.wrn(WR),
								.rdn(RD),
								.csn(CS0),
								.PLL_100M(PLL_100M),
								.RST_n(RST_n),
								.nadv(NADV)
								);

endmodule
