/* 
 * --------------------
 * Company					: LUOYANG GINGKO TECHNOLOGY CO.,LTD.
 * BBS						: http://www.eeschool.org
 * --------------------
 * Project Name			: SDRAM_Test_Top
 * Module Name				: SDRAM_Ctrl_Top
 * Description				: The codes of "SDRAM_Ctrl_Top"
 * --------------------
 * Tool Versions			: Quartus II 13.1
 * Target Device			: Cyclone IV E  EP4CE10F17C8
 * --------------------
 * Engineer					: woshi56hao
 * Revision					: V0.0
 * Created Date			: 2014-04-26
 * --------------------
 * Engineer					:
 * Revision					:
 * Modified Date			:
 * --------------------
 * Additional Comments	: SDRAM_Model	W9812G2IH
 * 
 * --------------------
 */

//--------------------Timescale------------------------------//
`timescale 1 ns / 1 ps

//--------------------Module_SDRAM_Ctrl_Top------------------//
module SDRAM_Ctrl_Top(
	SDRAM_CLK,		//输入SDRAM_Ctrl_Top模块主时钟,50M
	RST_n,			//输入全局复位信号
	SDRAM_Data_in,	//输入写入SDRAM的数据
	SD_WR_Req,		//输入写SDRAM请求信号
	SD_RD_Req,		//输入读SDRAM请求信号
	SD_WR_Ack,		//输出写应答信号
	SD_RD_Ack,		//输出读应答信号
	SD_Busy,			//输出忙信号
	SD_CKE,			//时钟使能信号
	SD_CS,			//片选信号
	SD_RAS,			//行选通信号
	SD_CAS,			//列选通信号
	SD_WE,			//读写控制信号
	SD_BA,			//Bank地址选择信号
	SD_AB,			//地址总线
	SD_DB,			//双向数据总线
	SD_DQM,			//数据屏蔽信号
	SDRAM_Data_out,//输出读SDRAM得到的数据
	Work_Cnt_CLK,	//输出SDRAM工作状态的时钟计数器
	Work_State,
	REF_Req,
	REF_Ack,
	Init_State,
	wr_ab,
	rd_ab
	);

	input  SDRAM_CLK,RST_n;
	input  [15:0] SDRAM_Data_in;
	input  SD_WR_Req,SD_RD_Req;
	input  REF_Req;
	input  [21:0]wr_ab,rd_ab;

	inout  [15:0] SD_DB;		//数据总线,双向
	output SD_WR_Ack,SD_RD_Ack,SD_Busy;
	output SD_CKE;
	output SD_CS,SD_RAS,SD_CAS,SD_WE;
	output [1:0] SD_BA;
	output [11:0] SD_AB;
	output [1:0] SD_DQM;
	output [15:0] SDRAM_Data_out;
	output [8:0] Work_Cnt_CLK;
	output REF_Ack;
	output [4:0]Init_State;
	output [2:0] Work_State;
//--------------------State_Ctrl-----------------------------//
	wire [4:0] Init_State,Init_Cnt_CLK;
	wire [8:0] Work_Cnt_CLK;
	wire [2:0] Work_State;

	State_Ctrl			U1(
								.SDRAM_CLK(SDRAM_CLK),
								.RST_n(RST_n),
								.SD_WR_Req(SD_WR_Req),
								.SD_RD_Req(SD_RD_Req),
								.SD_WR_Ack(SD_WR_Ack),
								.SD_RD_Ack(SD_RD_Ack),
								.SD_Busy(SD_Busy),
								.Init_State(Init_State),
								.Init_Cnt_CLK(Init_Cnt_CLK),
								.Work_State(Work_State),
								.Work_Cnt_CLK(Work_Cnt_CLK),
								.REF_Req(REF_Req),
								.REF_Ack(REF_Ack)
								);	//例化State_Ctrl模块,控制SDRAM的
									//上电初始化和正常工作状态及自动刷新
//--------------------CMD_Ctrl-------------------------------//
	CMD_Ctrl				U2(
								.SDRAM_CLK(SDRAM_CLK),
								.RST_n(RST_n),
								.Init_Stste(Init_State),
								.Init_Cnt_CLK(Init_Cnt_CLK),
								.Work_State(Work_State),
								.Work_Cnt_CLK(Work_Cnt_CLK),
								.SD_AB(SD_AB),
								.SD_BA(SD_BA),
								.SD_CS(SD_CS),
								.SD_CKE(SD_CKE),
								.SD_RAS(SD_RAS),
								.SD_CAS(SD_CAS),
								.SD_WE(SD_WE),
								.SD_DQM(SD_DQM),
								.wr_ab(wr_ab),
								.rd_ab(rd_ab)
								);	//例化CMD_Ctrl模块,根据State_Ctrl模块
									//输出的状态和计数器,发出相应的操作命令
//--------------------Data_Ctrl------------------------------//	
	Data_Ctrl			U3(
								.SDRAM_CLK(SDRAM_CLK),
								.RST_n(RST_n),
								.Work_State(Work_State),
								.Work_Cnt_CLK(Work_Cnt_CLK),
								.SDRAM_Data_in(SDRAM_Data_in),
								.SD_DB(SD_DB),
								.SDRAM_Data_out(SDRAM_Data_out)
								);	//例化Data_Ctrl模块,根据State_Ctrl模块
									//输出的状态和计数器,制数据的写入和读出
//--------------------Timescale------------------------------//
endmodule
