/* 
 * --------------------
 * Company					: LUOYANG GINGKO TECHNOLOGY CO.,LTD.
 * BBS						: http://www.eeschool.org
 * --------------------
 * Project Name			: SDRAM_Ctrl_Top
 * Module Name				: CMD_Ctrl
 * Description				: The codes of "CMD_Ctrl"
 * --------------------
 * Tool Versions			: Quartus II 13.1
 * Target Device			: Cyclone IV E  EP4CE10F17C8
 * --------------------
 * Engineer					: Xiaorenwu
 * Revision					: V0.0
 * Created Date			: 2014-04-26
 * --------------------
 * Engineer					:
 * Revision					:
 * Modified Date			:
 * --------------------
 * Additional Comments	: SDRAM_Model	W9812G2IH
 * 
 * --------------------
 */

//--------------------Timescale------------------------------//
`timescale 1 ns / 1 ps

//--------------------Module_CMD_Ctrl------------------------//
module CMD_Ctrl(
	SDRAM_CLK,		//输入SDRAM_Ctrl_Top模块主时钟,50M
	RST_n,			//输入全局复位信号
	Init_Stste,		//输入初始化状态
	Init_Cnt_CLK,	//输入初始化状态始终计数器
	Work_State,		//输入工作状态
	Work_Cnt_CLK,	//输入工作状态始终计数器
	SD_CKE,
	SD_BA,
	SD_AB,
	SD_CS,
	SD_RAS,
	SD_CAS,
	SD_WE,
	SD_DQM,
	wr_ab,
	rd_ab
	);

	input SDRAM_CLK,RST_n;
	input [4:0] Init_Stste,Init_Cnt_CLK;
	input [8:0] Work_Cnt_CLK;
	input [2:0] Work_State;
	input [21:0]wr_ab;
	input [21:0]rd_ab;
	
	output SD_CKE;
	output [1:0] SD_BA;
	output [11:0] SD_AB;
	output SD_CS,SD_RAS,SD_CAS,SD_WE;
	output [1:0]SD_DQM;

//--------------------Include--------------------------------//
	`include		"Para_Ctrl.v"	//在本模块加入全局变量定义文件
//--------------------SD_CMD---------------------------------//
	reg [1:0] SD_BA_r = 2'd0;//SDRAM的BA寄存器
	reg [11:0] SD_AB_r = 12'd0;//SDRAM的AB寄存器
	reg [4:0] SD_CMD = 5'd0;//SDRAM的命令寄存器
	always @(posedge SDRAM_CLK or negedge RST_n)
		if (!RST_n)
			begin
				SD_BA_r <= 2'b11;
				SD_AB_r <= 12'hFFF;
				SD_CMD <= `CMD_Init;//上电复位后,发送命令Init
			end
		else
			case (Init_Stste)
				`Init_NOP: begin
					SD_BA_r <= 2'b11;
					SD_AB_r <= 12'hFFF;
					SD_CMD <= `CMD_NOP;//空闲状态发送NOP命令
				end
				`Init_PCH: begin
					if (Init_Cnt_CLK == 5'd0)//进入预充电状态后第一个上升沿发送命令
						begin						//即为之前注释的发送命令滞后1个周期
							SD_BA_r <= 2'b11;
							SD_AB_r <= 12'hFFF;
							SD_CMD <= `CMD_PCH;//发送PCH命令
						end
					else SD_CMD <= `CMD_NOP;
				end
				`Init_AR1,`Init_AR2,`Init_AR3,`Init_AR4,
				`Init_AR5,`Init_AR6,`Init_AR7,`Init_AR8: begin
					if (Init_Cnt_CLK == 5'd0)
						begin
							SD_BA_r <= 2'b11;
							SD_AB_r <= 12'hFFF;
							SD_CMD <= `CMD_REF;//刷新状态发送刷新命令
						end
					else
						SD_CMD <= `CMD_NOP;
				end
				`Init_MRS: begin//模式寄存器设置状态
					if (Init_Cnt_CLK == 5'd0)//同PCH状态
						begin
							SD_BA_r <= 2'b00;		//必须为00
							SD_AB_r <= {2'b00,	//必须为00
											1'b1,		//写模式,0为突发读突发写,1为突发读单次写
											2'b00,	//必须为0
											3'b011,	//CL值,010为2,011为3
											1'b0,		//访问模式,0为顺序模式,1为交错模式
											3'b000};	//BL值,000为1,001为2,010为4,011为8,111为全页
							SD_CMD <= `CMD_MRS;	//进入MRS状态后,滞后1个周期发送MRS命令
						end
					else SD_CMD <= `CMD_NOP;
				end
				`Init_DONE: begin//初始化完成,进入正常工作状态
					case (Work_State)
						`Work_IDLE: begin
							SD_BA_r <= 2'b11;
							SD_AB_r <= 12'hFFF;
							SD_CMD <= `CMD_NOP;//空闲状态发送NOP命令
						end
						`Work_ACT_RD: begin//ACT状态时
							if (Work_Cnt_CLK == 9'd0)
								begin
									SD_BA_r <= rd_ab[21:20];//锁存Bank地址
									SD_AB_r <= rd_ab[19:8];//锁存行地址
									SD_CMD <= `CMD_ACT;//行命令激活
								end
							else 
								begin
									SD_BA_r <= 2'b11;
									SD_AB_r <= 12'hFFF;
									SD_CMD <= `CMD_NOP;
								end
						end
						`Work_ACT_WR: begin//ACT状态时
							if (Work_Cnt_CLK == 9'd0)
								begin
									SD_BA_r <= wr_ab[21:20];//锁存Bank地址
									SD_AB_r <= wr_ab[19:8];//锁存行地址
									SD_CMD <= `CMD_ACT;//行命令激活
								end
							else 
								begin
									SD_BA_r <= 2'b11;
									SD_AB_r <= 12'hFFF;
									SD_CMD <= `CMD_NOP;
								end
						end						
						`Work_WR: begin//写状态时
							if (Work_Cnt_CLK == 9'd0)
								begin
								SD_BA_r <= wr_ab[21:20];
									SD_AB_r <= {4'b0100,wr_ab[7:0]};//锁存列地址,同时A10为1,带预充电
									SD_CMD <= `CMD_WR;//发送带预充电的写命令,带预充电的读写命令在完成突发长度的读写后,会自动预充电然后回到IDLE
								end						//但在全页模式下,A10的值无意义,必须发送BST命令才能停止全页读写并保持当前行打开状态,否则会在一行循环读写
							else
								begin
									SD_BA_r <= 2'b11;
									SD_AB_r <= 12'hFFF;
									SD_CMD <= `CMD_NOP;
								end
						end
						`Work_RD: begin//读状态时
							if (Work_Cnt_CLK == 9'd0)
								begin
									SD_BA_r <= rd_ab[21:20];
									SD_AB_r <= {4'b0000,rd_ab[7:0]};//锁存列地址,同时A10为1,带预充电
									SD_CMD <= `CMD_RD;//发送带预充电的读命令
								end
							else if (Work_Cnt_CLK == 9'd5)//发送PCH命令关闭当前行,回到IDLE状态等待下一次读写
								begin
									SD_CMD <= `CMD_PCH;
									SD_BA_r <= rd_ab[21:20];
									SD_AB_r <= 12'hFFF;
								end
							else
								begin
									SD_BA_r <= 2'b11;
									SD_AB_r <= 12'hFFF;
									SD_CMD <= `CMD_NOP;
								end
						end
						`Work_AR: begin//自动刷新
							if (Work_Cnt_CLK == 9'd0)
								begin
									SD_BA_r <= 2'b11;
									SD_AB_r <= 12'hFFF;
									SD_CMD <= `CMD_REF;//发送自动刷新命令
								end
							else begin
									SD_CMD <= `CMD_NOP;
									SD_BA_r <= 2'b11;
									SD_AB_r <= 12'hFFF;
								end
						end
						default: begin
							SD_BA_r <= 2'b11;
							SD_AB_r <= 12'hFFF;
							SD_CMD <= `CMD_NOP;//默认空命令
						end
					endcase
				end
				default: begin
					SD_BA_r <= 2'b11;
					SD_AB_r <= 12'hFFF;
					SD_CMD <= `CMD_NOP;//默认空命令
				end
			endcase

	assign SD_BA = SD_BA_r;//输出SDRAM的BA
	assign SD_AB = SD_AB_r;//输出SDRAM的AB
	assign {SD_CKE,SD_CS,SD_RAS,SD_CAS,SD_WE} = SD_CMD;//输出命令
	assign SD_DQM = 2'd0;//一直为低,不屏蔽数据
//--------------------Endmodule------------------------------//
endmodule
	