/* 
 * --------------------
 * Company					: LUOYANG GINGKO TECHNOLOGY CO.,LTD.
 * BBS						: http://www.eeschool.org
 * --------------------
 * Project Name			: SDRAM_Test_Top
 * Module Name				: Data_Generator
 * Description				: The codes of "Data_Generator"
 * --------------------
 * Tool Versions			: Quartus II 13.1
 * Target Device			: Cyclone IV E  EP4CE10F17C8
 * --------------------
 * Engineer					: Xiaorenwu
 * Revision					: V0.0
 * Created Date			: 2014-04-26
 * --------------------
 * Engineer					:
 * Revision					:
 * Modified Date			:
 * --------------------
 * Additional Comments	: SDRAM_Model	W9812G2IH
 * 
 * --------------------
 */

//--------------------Timescale------------------------------//
`timescale 1 ns / 1 ps

//--------------------Module_Data_Generator------------------//
module Data_Generator(
	SDRAM_CLK,			//输入PLL模块输出的时钟,50M
	RST_n,			//输入全局复位信号
	SD_Busy,			//输入SDRAM_Ctrl_Top模块输出的忙信号
	SD_WR_Ack,		//输入SDRAM_Ctrl_Top模块输出的写应答信号
	SD_RD_Ack,		//输入SDRAM_Ctrl_Top模块输出的读应答信号
	SD_WR_Req,		//输出写请求信号
	SD_RD_Req,		//输出读请求信号
	Sys_Data_out,	//输出要写入SDRAM的数据
	rd_ab,
	wr_ab,
	SDRAM_Data_out,
	FPGA_LEDB,
	FPGA_LEDG,
	FPGA_LEDR,
	REF_Ack,
	REF_Req
	);

	input SDRAM_CLK,RST_n;
	input SD_Busy,SD_RD_Ack,SD_WR_Ack;
	input [15:0]SDRAM_Data_out;
	input  REF_Ack;
	
	output SD_WR_Req,SD_RD_Req;
	output [15:0] Sys_Data_out;
	output [21:0]wr_ab;
	output [21:0]rd_ab;
	output REF_Req;
	output FPGA_LEDB,FPGA_LEDG,FPGA_LEDR;
//--------------------Data_Generator_FSM---------------------//
	reg SD_WR_Req_r;//写请求寄存器
	reg SD_RD_Req_r;//读请求寄存器
	reg [15:0] Sys_Data_out_r;//要写入SDRAM的数据寄存器
	reg [19:0] RD_AB;
	reg [19:0] WR_AB;							
	reg [3:0]i;
	reg [1:0]bank;
	reg [1:0]BANK;
	reg [19:0]wa;
	reg led1,led2,led3;
	reg [3:0]q;
	reg [19:0]p;
	reg [19:0]data_in,data_out;
	reg REF_Req_r;
	reg [23:0]cnt;
	reg [27:0]counter;
	
	always @ (posedge SDRAM_CLK or negedge RST_n)
		if (!RST_n)
			REF_Req_r <= 1'd0;
		else if ((!SD_Busy) && (cnt <= 24'hfffff))
			begin
				REF_Req_r <= 1'd1;
				if (REF_Ack)//应答刷新请求
					REF_Req_r <= 1'd0;//请求信号为0
			end
		else 
			begin
				if (REF_Ack)//应答刷新请求
					REF_Req_r <= 1'd0;//请求信号为0
			end
			
	always @ (posedge SDRAM_CLK or negedge RST_n)
		if (!RST_n)
			cnt <= 24'd0;
		else if (cnt == 24'hffffff)
			cnt <= 24'd0;
		else cnt <= cnt + 1'd1;
	
	always @(posedge SDRAM_CLK or negedge RST_n)
		if (!RST_n)
			begin
				i <= 4'd0;
				SD_WR_Req_r <= 1'd0;
				WR_AB <= 20'd0;
				RD_AB <= 20'd0;
				Sys_Data_out_r <= 16'd0;
				BANK <= 2'd0;
				bank <= 2'd0;
				data_in <= 20'd0;
				data_out <= 20'd0;
				led1 <= 1'd1;
				led2 <= 1'd1;
				led3 <= 1'd1;
				p <= 20'd0;
				q <= 4'd0;
				counter <= 28'd0;
			end
		else case(i)
			4'd0:
				begin
					if ((!SD_Busy) && (cnt >= 24'hfffff))
						begin
							BANK <= bank;
							WR_AB <= data_in;
							Sys_Data_out_r <= data_in[15:0];
							SD_WR_Req_r <= 1'd1;//发出写请求,同时发出写地址
							led1 <= 1'd0;
							i <= 4'd1;
						end
					else i <= 4'd0;
				end
			4'd1:
				begin
					if (SD_WR_Ack)//等待SDRAM控制模块发出写应答信号
						begin
							if (data_in == 20'hfffff)
								begin
									if(bank == 2'd3)
										begin
											data_in <= 20'd0;
											SD_WR_Req_r <= 1'd0;//写请求信号撤销
											bank <= 2'd0;
											i <= 4'd2;
										end
									else 
										begin
											data_in <= 20'd0;
											SD_WR_Req_r <= 1'd0;//写请求信号撤销
											bank <= bank + 1'd1;
											i <= 4'd0;
										end	
								end
							else
								begin
									SD_WR_Req_r <= 1'd0;//写请求信号撤销
									i <= 4'd0;
									data_in <= data_in + 1'd1;
								end
						end
					else i <= 4'd1;
				end
			4'd2:
				begin
					if((!SD_Busy) && (cnt >= 24'hfffff))//等待SDRAM控制模块不忙
						begin
							SD_RD_Req_r <= 1'd1;//发出读请求信号,同时发出读地址
							RD_AB <= data_out;
							BANK <= bank;
							i <= 4'd3;
						end
					else
						i <= 4'd2;
				end
			4'd3:
				begin
					if(SD_RD_Ack)					//等待SDRAM控制模块发出读应答信号
						begin
							SD_RD_Req_r <= 1'd0;	//读请求信号撤销
							i <= 4'd4;
						end
					else
						i <= 4'd3;
				end
			4'd4:
				begin
					if (q == 4'd7)
						begin
							q <= 4'd0;
							i <= 4'd5;
						end
					else
						begin
							i <= 4'd4;
							q <= q + 1'd1;
						end
					end
			4'd5:
				begin
					if (SDRAM_Data_out == data_out[15:0])//判断数据是否正确
						begin
							if (data_out == 20'hfffff)
								begin
									if (bank == 2'd3)
										begin
											data_out <= 20'd0;
											i <= 4'd7;
										end
									else 
										begin
											data_out <= 20'd0;
											bank <= bank + 1'd1;
											i <= 4'd2;
										end	
								end
							else 
								begin
									data_out <= data_out + 1'd1;
									i <= 4'd2;
								end
						end
					else i <= 4'd8;
				end
			4'd7:		//结束
				begin
					if(counter == 28'h4000000)
						begin
							led1 <= 1'd0;
							led2 <= 1'd1;
							led3 <= 1'd1;
						end
					else if(counter == 28'h8000000)
						begin
							led1 <= 1'd1;
							led2 <= 1'd0;
							led3 <= 1'd1;
						end
					else if(counter == 28'hC000000)
						begin
							led1 <= 1'd1;
							led2 <= 1'd1;
							led3 <= 1'd0;		
						end
					if(counter == 28'hC000000)
						begin
							counter <= 28'd0;
						end
					else 
						begin
							counter <= counter + 1'd1;
						end		
				end
			4'd8:		//报错
				begin
					if (p == 20'd1000000)
						begin
							p <= 20'd0;
							i <= 4'd8;
						end
					else
						begin
							p <= p + 1'd1;
							led1 <= 1'd0;
							led3 <= 1'd0;
							led2 <= 1'd0;
						end
				end
			default: i <= 4'd0;
		endcase

	assign FPGA_LEDG = led1;
	assign FPGA_LEDB = led2;	
	assign FPGA_LEDR = led3;
	
	assign SD_WR_Req = SD_WR_Req_r;//输出写请求信号
	assign SD_RD_Req = SD_RD_Req_r;//输出读请求信号
	assign Sys_Data_out = Sys_Data_out_r;//输出要写入SDRAM的数据
	assign rd_ab = {BANK,RD_AB};
	assign wr_ab = {BANK,WR_AB};
	assign REF_Req = REF_Req_r;		//输出刷新请求信号
//--------------------Endmodule------------------------------//
	endmodule
