 /*
 * FILE								: rtc.c
 * DESCRIPTION				: This file is evc8021 exit driver.
 * Author							: ysloveivy
 * Copyright					:
 *
 * History
 * -------------------
 * Rev								: 0.00
 * Date								: 12/03/2014
 *
 * create.
 * -------------------
 */
 
//----------------------include----------------------------//
#include "..\include\rtc.h"
#include "..\fwlib\inc\stm32f4xx_rtc.h"
#include "..\fwlib\inc\stm32f4xx_rcc.h"
//------------------ Function Prototype ------------------//
static int initialize(void);
static int rtc_set_time(unsigned char hour,unsigned char min,unsigned char sec,unsigned char ampm);
static int rtc_set_date(unsigned char year,unsigned char month,unsigned char date,unsigned char week);
//----------------------variable--------------------------//
RTC_T rtc = {
	.initialize = initialize
};
//-----------------Function-----------------------------//

/*
 * Name								: initialize
 * Description				: ---
 * Author							: ysloveivy.
 *
 * History
 * -------------------
 * Rev								: 0.00
 * Date								: 12/03/2014
 * 
 * create.
 * -------------------
 */
static int initialize(void)
{
	if(RTC_ReadBackupRegister(RTC_BKP_DR0) != 0x32F2){
		RCC_APB1PeriphClockCmd(RCC_APB1Periph_PWR, ENABLE);
		PWR_BackupAccessCmd(ENABLE);
		RCC_BackupResetCmd(ENABLE);
		RCC_BackupResetCmd(DISABLE);

		RCC_LSEConfig(RCC_LSE_ON);//LSE     
		while (RCC_GetFlagStatus(RCC_FLAG_LSERDY) == RESET);	//ָRCC־λ,ȴپ
			
		RCC_RTCCLKConfig(RCC_RTCCLKSource_LSE);		//RTCʱ(RTCCLK),ѡLSEΪRTCʱ    
		RCC_RTCCLKCmd(ENABLE);	//ʹRTCʱ 
		
		RTC_WaitForSynchro();

		rtc_set_time(5,13,56,RTC_H12_PM);	//ʱ
		rtc_set_date(15,10,27,2);		//
		
		RTC_WriteBackupRegister(RTC_BKP_DR0, 0x32F2);
	}
	 
	return 0;
}
/*
 * Name								: initialize
 * Description				: ---
 * Author							: ysloveivy.
 *
 * History
 * -------------------
 * Rev								: 0.00
 * Date								: 12/03/2014
 * 
 * create.
 * -------------------
 */
 static int rtc_set_time(unsigned char hour,unsigned char min,unsigned char sec,unsigned char ampm)
{
	RTC_TimeTypeDef RTC_TimeTypeInitStructure;
	
	RTC_TimeTypeInitStructure.RTC_Hours=hour;
	RTC_TimeTypeInitStructure.RTC_Minutes=min;
	RTC_TimeTypeInitStructure.RTC_Seconds=sec;
	RTC_TimeTypeInitStructure.RTC_H12=ampm;
	
	RTC_SetTime(RTC_Format_BIN,&RTC_TimeTypeInitStructure);
	
	return 0;
}
/*
 * Name								: initialize
 * Description				: ---
 * Author							: ysloveivy.
 *
 * History
 * -------------------
 * Rev								: 0.00
 * Date								: 12/03/2014
 * 
 * create.
 * -------------------
 */
static int rtc_set_date(unsigned char year,unsigned char month,unsigned char date,unsigned char week)
{
	
	RTC_DateTypeDef RTC_DateTypeInitStructure;
	RTC_DateTypeInitStructure.RTC_Date=date;
	RTC_DateTypeInitStructure.RTC_Month=month;
	RTC_DateTypeInitStructure.RTC_WeekDay=week;
	RTC_DateTypeInitStructure.RTC_Year=year;
	
	RTC_SetDate(RTC_Format_BIN,&RTC_DateTypeInitStructure);
	
	return 0;
}
