 /*
 * FILE								: fpga_ps.c
 * DESCRIPTION				: This file is iCore3 fpga_ps driver.
 * Author							: ysloveivy
 * Copyright					:
 *
 * History
 * -------------------
 * Rev								: 0.00
 * Date								: 12/03/2014
 *
 * create.
 * -------------------
 */
 
//----------------------include----------------------------//
#include "..\include\fpga_ps.h"
#include "..\fwlib\inc\stm32f4xx_gpio.h"
#include "..\fatfs\ff.h"
#include "..\fatfs\diskio.h"
#include "stm324xg_eval_sdio_sd.h"
#include "..\include\usart.h"

//------------------ Function Prototype ------------------//
static int initialize(void);
static int from_tf(void);
static int from_udisk(void);
static int ps(FIL *);
//----------------------variable--------------------------//
FPGA_PS_T fpga_ps = {
	.initialize = initialize,
	.from_tf = from_tf,
	.from_udisk = from_udisk
};

extern FATFS fatfs0,fatfs1;
//-----------------Function-----------------------------//
/*
 * Name								: initialize
 * Description				: ---
 * Author							: ysloveivy.
 *
 * History
 * -------------------
 * Rev								: 0.00
 * Date								: 12/03/2014
 * 
 * create.
 * -------------------
 */
static int initialize(void)
{
	GPIO_InitTypeDef   GPIO_uInitStructure;
	
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOG,ENABLE);
	
	GPIO_uInitStructure.GPIO_Pin = GPIO_Pin_4 | GPIO_Pin_5 | GPIO_Pin_6;
	GPIO_uInitStructure.GPIO_Mode = GPIO_Mode_OUT;
	GPIO_uInitStructure.GPIO_OType = GPIO_OType_PP;  
	GPIO_uInitStructure.GPIO_PuPd = GPIO_PuPd_UP;
	GPIO_uInitStructure.GPIO_Speed = GPIO_Speed_100MHz;  // 100M
	
	GPIO_Init(GPIOG,&GPIO_uInitStructure);
	
	GPIO_uInitStructure.GPIO_Pin = GPIO_Pin_7 | GPIO_Pin_15;												//ӰIO˿
  GPIO_uInitStructure.GPIO_Mode = GPIO_Mode_IN;											//ö˿Ϊģʽ
  GPIO_uInitStructure.GPIO_Speed = GPIO_Speed_100MHz;							//ٶΪ
  GPIO_uInitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;									//˿ڲ仯 
  GPIO_Init(GPIOG, &GPIO_uInitStructure);														//õĲõṹ

	return 0;
}
/*
 * Name								: from_tf
 * Description				: ---
 * Author							: ysloveivy.
 *
 * History
 * -------------------
 * Rev								: 0.00
 * Date								: 12/03/2014
 * 
 * create.
 * -------------------
 */
static int from_tf(void)
{
	FIL fil;
	FRESULT res;

		
	res = f_open(&fil,"0:/sdram.rbf",FA_READ);
		
	if(res != RES_OK){
		usart4.printf(" *f_open error!\r\n");
		return -1;
	}
	res = f_lseek(&fil,0);
	if(res != RES_OK){
		usart4.printf(" *f_lseek error!\r\n");
		return -1;
	}
	
	return ps(&fil);
	
	
}

/*
 * Name								: from_udisk
 * Description				: ---
 * Author							: ysloveivy.
 *
 * History
 * -------------------
 * Rev								: 0.00
 * Date								: 12/03/2014
 * 
 * create.
 * -------------------
 */
static int from_udisk(void)
{
	FIL fil;
	FRESULT res;

	res = f_open(&fil,"1:/sdram.rbf",FA_READ);
		
	if(res != RES_OK){
		usart4.printf(" *f_open error!\r\n");
		return -1;
	}
	res = f_lseek(&fil,0);
	if(res != RES_OK){
		usart4.printf(" *f_lseek error!\r\n");
		return -1;
	}
	
	return ps(&fil);
	
	
}
/*
 * Name								: ps
 * Description				: ---
 * Author							: ysloveivy.
 *
 * History
 * -------------------
 * Rev								: 0.00
 * Date								: 12/03/2014
 * 
 * create.
 * -------------------
 */
static int ps(FIL *f)
{	
	int i;
	int k;
	unsigned int counter;
	unsigned long int ncounter = 0;
	unsigned char buffer[1024];
	FRESULT res;
	
	NCONFIG_OFF;
	DCLK_OFF;
	for(i = 0; i < 5000; i++);
	if(NSTATUS == 1){
		usart4.printf("\r\n *fpga error!\r\n");
		return -1;
	}
	for(i = 0;i < 40;i++);
	NCONFIG_ON;
	for(i = 0; i < 40; i++);

	while(ncounter < f->fsize)	{
    res = f_read(f,buffer,1024,&counter);
		if(res != RES_OK){
			usart4.printf("\r\n *f_read error!\r\n");
			return -1;
		}
		for(k = 0; k < counter; k++) {
		  for(i = 0; i < 8; i++) {
	      if(buffer[k]&0x01)DATA0_ON;
				else DATA0_OFF;
				DCLK_ON;
				buffer[k] >>= 1;
			  DCLK_OFF;
	    }
		  ncounter++;
	  }
  }	
	
	if(CONFIG_DONE != 1){
		usart4.printf("\r\n *config error!\r\n");
		return -1;
	}
	
	for(i = 0; i < 40; i++) {
     DCLK_ON;
		 for(i = 0; i < 800; i++);//delay 100us
		 DCLK_OFF;
		 for(i = 0; i < 800; i++);//delay 100us
	}	
	return 0;
}
