/* 
 * --------------------
 * Company					: LUOYANG GINGKO TECHNOLOGY CO.,LTD.
 * BBS						: http://www.eeschool.org
 * --------------------
 * Project Name			: SDRAM_Ctrl_Top
 * Module Name				: State_Ctrl
 * Description				: The codes of "State_Ctrl"
 * --------------------
 * Tool Versions			: Quartus II 13.1
 * Target Device			: Cyclone IV E  EP4CE10F17C8
 * --------------------
 * Engineer					: Xiaorenwu
 * Revision					: V0.0
 * Created Date			: 2014-04-26
 * --------------------
 * Engineer					:
 * Revision					:
 * Modified Date			:
 * --------------------
 * Additional Comments	: SDRAM_Model	W9812G2IH
 * 
 * --------------------
 */ 
//初始化
//--------------------Timescale------------------------------//
`timescale 1 ns / 1 ps

//--------------------Module_State_Ctrl----------------------//
module State_Ctrl(
	SDRAM_CLK,		//输入SDRAM_Ctrl_Top模块主时钟,50M
	RST_n,			//输入全局复位信号
	SD_WR_Req,		//输入写请求信号
	SD_RD_Req,		//输入读请求信号
	REF_Req,
	SD_WR_Ack,		//输出写应答信号
	SD_RD_Ack,		//输出读应答信号
	SD_Busy,			//输出忙信号
	Init_State,		//输出初始化状态
	Work_State,		//输出正常工作状态
	Init_Cnt_CLK,	//输出初始化状态时钟计数器
	Work_Cnt_CLK,	//输出正常工作状态时钟计数器
	REF_Ack
	);

	input  SDRAM_CLK,RST_n;
	input  SD_WR_Req,SD_RD_Req;
	input  REF_Req;
	
	output SD_WR_Ack,SD_RD_Ack;
	output [4:0] Init_State,Init_Cnt_CLK;
	output [8:0] Work_Cnt_CLK;
	output [2:0] Work_State;
	output SD_Busy;
	output REF_Ack;

//--------------------Include--------------------------------//
	`include		"Para_Ctrl.v"	//在本模块加入全局变量定义文件

//====================Initial_State==========================//
//初始化状态：200us的稳定期+所有Bank预充电+8次自动刷新+模式寄存器设置
//--------------------Done_200us-----------------------------//
	reg [15:0] cnt_200us = 16'd0;
	always @(posedge SDRAM_CLK or negedge RST_n)
		if (!RST_n)
			cnt_200us <= 16'd0;
		else if (cnt_200us < 16'd20000)
			cnt_200us <= cnt_200us + 1'd1;

	wire done_200us = (cnt_200us == 16'd20000); //200us稳定期完成信号

//--------------------Init_FSM-------------------------------//	
	reg [4:0] cnt_clk_i = 5'd0;//初始化时钟计数器
	reg [4:0] Init_State_r = 5'd0;//初始化状态寄存器

	always @(posedge SDRAM_CLK or negedge RST_n)
		if (!RST_n)
			begin
				cnt_clk_i <= 5'd0;
				Init_State_r <= `Init_NOP;//上电复位后处于NOP状态
			end
		else
			case (Init_State)
				`Init_NOP: begin
					cnt_clk_i <= 5'd0;
					if (done_200us)//200us稳定期完成
						Init_State_r <= `Init_PCH;//进入所有Bank预充电状态
					else
						Init_State_r <= `Init_NOP;
				end
				`Init_PCH: begin
					if (cnt_clk_i == 5'd9)//预充电占用10个周期
						begin
							Init_State_r <= `Init_AR1;//进入8次自动刷新状态
							cnt_clk_i <= 5'd0;
						end
					else
						begin
							Init_State_r <= `Init_PCH;
							cnt_clk_i <= cnt_clk_i + 1'd1;
						end
				end
				`Init_AR1: begin	//第一次自动刷新
					if (cnt_clk_i == 5'd9)//自动刷新占用10个周期
						begin
							Init_State_r <= `Init_AR2;
							cnt_clk_i <= 5'd0;
						end
					else
						begin
							Init_State_r <= `Init_AR1;
							cnt_clk_i <= cnt_clk_i + 1'd1;
						end
				end
				`Init_AR2: begin	//第二次自动刷新
					if (cnt_clk_i == 5'd9)
						begin
							Init_State_r <= `Init_AR3;
							cnt_clk_i <= 5'd0;
						end
					else
						begin
							Init_State_r <= `Init_AR2;
							cnt_clk_i <= cnt_clk_i + 1'd1;
						end
				end
				`Init_AR3: begin	//第三次
					if (cnt_clk_i == 5'd9)
						begin
							Init_State_r <= `Init_AR4;
							cnt_clk_i <= 5'd0;
						end
					else
						begin
							Init_State_r <= `Init_AR3;
							cnt_clk_i <= cnt_clk_i + 1'd1;
						end
				end
				`Init_AR4: begin	//第四次
					if (cnt_clk_i == 5'd9)
						begin
							Init_State_r <= `Init_AR5;
							cnt_clk_i <= 5'd0;
						end
					else
						begin
							Init_State_r <= `Init_AR4;
							cnt_clk_i <= cnt_clk_i + 1'd1;
						end
				end
				`Init_AR5: begin	//第五次
					if (cnt_clk_i == 5'd9)
						begin
							Init_State_r <= `Init_AR6;
							cnt_clk_i <= 5'd0;
						end
					else
						begin
							Init_State_r <= `Init_AR5;
							cnt_clk_i <= cnt_clk_i + 1'd1;
						end
				end
				`Init_AR6: begin	//第六次
					if (cnt_clk_i == 5'd9)
						begin
							Init_State_r <= `Init_AR7;
							cnt_clk_i <= 5'd0;
						end
					else
						begin
							Init_State_r <= `Init_AR6;
							cnt_clk_i <= cnt_clk_i + 1'd1;
						end
				end
				`Init_AR7: begin	//第七次
					if (cnt_clk_i == 5'd9)
						begin
							Init_State_r <= `Init_AR8;
							cnt_clk_i <= 5'd0;
						end
					else
						begin
							Init_State_r <= `Init_AR7;
							cnt_clk_i <= cnt_clk_i + 1'd1;
						end
				end
				`Init_AR8: begin	//第八次
					if (cnt_clk_i == 5'd9)
						begin
							Init_State_r <= `Init_MRS;
							cnt_clk_i <= 5'd0;
						end
					else
						begin
							Init_State_r <= `Init_AR8;
							cnt_clk_i <= cnt_clk_i + 1'd1;
						end
				end
				`Init_MRS: begin	//模式寄存器设置状态
					if (cnt_clk_i == 5'd4)	//占用5个周期
						begin
							Init_State_r <= `Init_DONE; //初始化完成
							cnt_clk_i <= 5'd0;
						end
					else
						begin
							Init_State_r <= `Init_MRS;
							cnt_clk_i <= cnt_clk_i + 1'd1;
						end
				end
				`Init_DONE: begin //初始化完成
					Init_State_r <= `Init_DONE;
				end
				default: Init_State_r <= `Init_NOP;
			endcase

	assign Init_State = Init_State_r; //输出初始化状态
	assign Init_Cnt_CLK = cnt_clk_i; //输出初始化状态时钟计数器
	wire SD_Init_Done = (Init_State_r == `Init_DONE);//初始化完成标志

//====================Work_State=============================//

//--------------------Work_FSM-------------------------------//	
	reg [2:0] Work_State_r = 3'd0;//工作状态寄存器
	reg [8:0] cnt_clk_w = 9'd0;//工作状态时钟计数器
	reg wr_sig;
	always @(posedge SDRAM_CLK or negedge RST_n)
		if (!RST_n)
			Work_State_r <= `Work_IDLE;//上电复位处于IDLE状态
		else
			case (Work_State_r)
				`Work_IDLE: begin
					cnt_clk_w <= 9'd0;
					if (SD_Init_Done && SD_RD_Req)//初始化完成且
						Work_State_r <= `Work_ACT_RD;//有读写请求,进入ACT状态
					else if (SD_Init_Done && SD_WR_Req)
						Work_State_r <= `Work_ACT_WR;
					else if (SD_Init_Done && REF_Req)//初始化完成且有刷新请求
						Work_State_r <= `Work_AR;//进入刷新状态
					else Work_State_r <= `Work_IDLE;
				end
				`Work_ACT_RD: begin
					if (cnt_clk_w == 9'd3)//ACT占用3个周期
						begin
							cnt_clk_w <= 9'd0;//时钟计数器清零
							Work_State_r <= `Work_RD;//根据读写信号
						end								 //决定是进入WR状态还是RD状态
					else
						begin
							cnt_clk_w <= cnt_clk_w + 1'd1;//自加1
							Work_State_r <= `Work_ACT_RD;
						end
				end
				
				`Work_ACT_WR: begin
					if (cnt_clk_w == 9'd2)//ACT占用3个周期
						begin
							cnt_clk_w <= 9'd0;//时钟计数器清零
							Work_State_r <= `Work_WR;//根据读写信号
						end												//决定是进入WR状态还是RD状态
					else
						begin
							cnt_clk_w <= cnt_clk_w + 1'd1;//自加1
							Work_State_r <= `Work_ACT_WR;
						end
				end

				`Work_WR: begin//写状态
					if (cnt_clk_w == 9'd3)//写状态占用258个周期,发送写命令滞后占用1个周期
						begin						//写操作占用256个周期,写入最后一个数据的同时
							cnt_clk_w <= 9'd0;//发生BST(突发停止)命令,然后预充电占用1个周期
							Work_State_r <= `Work_IDLE;
						end
					else
						begin
							cnt_clk_w <= cnt_clk_w + 1'd1;
							Work_State_r <= `Work_WR;
						end
				end
				`Work_RD: begin//读状态
					if (cnt_clk_w == 9'd5)//读状态占用260个周期,发送读命令滞后占用1个周期
						begin						//CL延时占用3个周期,读操作占用256个周期
						cnt_clk_w <= 9'd0;//BST和预充电命令在CL延时的3个周期内发送,不额外占用时间
							Work_State_r <= `Work_IDLE;//读完成后进入空闲状态
						end
					else
						begin
							cnt_clk_w <= cnt_clk_w + 1'd1;
							Work_State_r <= `Work_RD;
						end
				end
				`Work_AR: begin//自动刷新状态
					if (cnt_clk_w == 9'd9)//占用10个周期
						begin
							cnt_clk_w <= 9'd0;
							Work_State_r <= `Work_IDLE;//刷新完成后进入空闲状态
						end
					else
						begin
							cnt_clk_w <= cnt_clk_w + 1'd1;
							Work_State_r <= `Work_AR;
						end
				end
				default: begin
					cnt_clk_w <= 9'd0;
					Work_State_r <= `Work_IDLE;
				end
			endcase

	assign Work_State = Work_State_r;//输出工作状态
	assign Work_Cnt_CLK = cnt_clk_w;//输出工作状态时钟计数器
	assign SD_WR_Ack = (Work_State == `Work_WR);//输出写应答信号
	assign SD_RD_Ack = (Work_State == `Work_RD);//输出读应答信号
	assign REF_Ack = (Work_State == `Work_AR);//刷新应答信号
	assign SD_Busy = !((Init_State == `Init_DONE) && (Work_State == `Work_IDLE));//输出忙信号													
//--------------------SD_DQMM---------------------------------//


//--------------------Endmodule------------------------------//
endmodule
