 /*
 * FILE								: systick.c
 * DESCRIPTION				: This file is systick driver.
 * Author							: ysloveivy
 * Copyright					:
 *
 * History
 * -------------------
 * Rev								: 0.00
 * Date								: 12/03/2014
 *
 * create.
 * -------------------
 */
 
//----------------------include----------------------------//
#include "..\include\systick.h"
#include "..\fwlib\inc\stm32f4xx_syscfg.h"
#include "..\include\key.h"
#include "..\include\led.h"

//------------------ Function Prototype ------------------//
static int initialize(void);

//----------------------variable--------------------------//
SYSTICK_T systick = {
	.initialize = initialize,
	.second_flag = 0
};
int event = 0;

 
//-----------------Function-----------------------------//

/*
 * Name								: initialize
 * Description				: ---
 * Author							: ysloveivy.
 *
 * History
 * -------------------
 * Rev								: 0.00
 * Date								: 12/03/2014
 * 
 * create.
 * -------------------
 */

static int initialize(void)
{
	//ʱ1ms
	if(SysTick_Config(SystemCoreClock / 1000)){
		while(1);
	}
	return 0;
}
/*
 * Name								: SysTick_Handler
 * Description				: ---
 * Author							: ysloveivy.
 *
 * History
 * -------------------
 * Rev								: 0.00
 * Date								: 12/03/2014
 * 
 * create.
 * -------------------
 */
void SysTick_Handler(void)
{
	static int led_flag = 0;
	static int counter = 0;
	static int counter2 = 0;
	static int key_code_bak = 0;
	int key_code = 0;
	
	
	if((counter ++ % 1000) == 0){
		systick.second_flag = 1;
		led_flag ++;
	
	if((led_flag % 3) == 0){
		LED_RED_ON;
		LED_BLUE_OFF;
		LED_GREEN_OFF;
	}else if((led_flag % 3) == 1){
		LED_RED_OFF;
		LED_BLUE_ON;
		LED_GREEN_OFF;			
	}else if((led_flag % 3) == 2){
		LED_RED_OFF;
		LED_BLUE_OFF;
		LED_GREEN_ON;	
	}
}

	
 if((counter2 ++ % 100) == 0){
		//read key
		key_code = key.read();

	if (key_code == key_code_bak || key_code == 0) {
		key_code_bak = key_code;
		return;
	}
	event = key_code;
	key_code_bak = key_code;
		
	 
	}
	
}
