 /*
 * FILE								: led.c
 * DESCRIPTION				: This file is evc8021 exit driver.
 * Author							: ysloveivy
 * Copyright					:
 *
 * History
 * -------------------
 * Rev								: 0.00
 * Date								: 12/03/2014
 *
 * create.
 * -------------------
 */
 
//----------------------include----------------------------//
#include "..\include\key.h"
#include "..\fwlib\inc\stm32f4xx_gpio.h"

//------------------ Function Prototype ------------------//
static int initialize(void);
static int read(void);

//----------------------variable--------------------------//
KEY_T key = {
	.initialize = initialize,
	.read = read
};
//-----------------Function-----------------------------//

/*
 * Name								: initialize
 * Description				: ---
 * Author							: ysloveivy.
 *
 * History
 * -------------------
 * Rev								: 0.00
 * Date								: 12/03/2014
 * 
 * create.
 * -------------------
 */

static int initialize(void)
{
	GPIO_InitTypeDef   GPIO_uInitStructure;
	
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOH,ENABLE);
	GPIO_uInitStructure.GPIO_Pin = GPIO_Pin_15;												//ӰIO˿
  GPIO_uInitStructure.GPIO_Mode = GPIO_Mode_IN;											//ö˿Ϊģʽ
  GPIO_uInitStructure.GPIO_Speed = GPIO_Speed_100MHz;							//ٶΪ
  GPIO_uInitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;									//˿ڲ仯 
  GPIO_Init(GPIOH, &GPIO_uInitStructure);														//õĲõṹ
	
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOG,ENABLE);
	GPIO_uInitStructure.GPIO_Pin = GPIO_Pin_14;												//ӰIO˿
  GPIO_uInitStructure.GPIO_Mode = GPIO_Mode_IN;											//ö˿Ϊģʽ
  GPIO_uInitStructure.GPIO_Speed = GPIO_Speed_100MHz;							//ٶΪ
  GPIO_uInitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;									//˿ڲ仯 
  GPIO_Init(GPIOG, &GPIO_uInitStructure);														//õĲõṹ

	return 0;
}
/*
 * Name								: read
 * Description				: ---
 * Author							: ysloveivy.
 *
 * History
 * -------------------
 * Rev								: 0.00
 * Date								: 12/03/2014
 * 
 * create.
 * -------------------
 */
static int read(void)
{
	int key_code = 0;
	
	if(KEY_INPUT == 0)key_code |= 1;
	if(FPGA_KEY_INPUT == 0)key_code |= 2;
	
	return key_code;
}

